﻿//////////////////////////////////////////////
// ImageDisplay.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Image ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Enums ------------------------------------

namespace nkWinUi
{
	enum class IMAGE_DISPLAY_METHOD
	{
		STRETCH = 0,
		KEEP_RATIO
	} ;
}

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT ImageDisplay : public Component
	{
		public :
		
			// Constructor, destructor
			ImageDisplay (System* system) noexcept ;
			virtual ~ImageDisplay () ;

			// Getters
			Image* getImage () const ;
			IMAGE_DISPLAY_METHOD getDisplayMethod () const ;

			// Setters
			virtual void setImage (Image* value) ;
			virtual void setDisplayMethod (IMAGE_DISPLAY_METHOD value) ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<ImageDisplay> create (System* system = nullptr) ;

		protected :

			// Attributes
			Image* _image ;

			IMAGE_DISPLAY_METHOD _displayMethod ;
	} ;
}